/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;

public class ClementsChecklistWriter {
    static String CODE_PREFIX = "code";
    static String ID_PREFIX = "id";
    static String PARK_PREFIX = "park";
    static String TOWN_PREFIX = "town";
    static String CITY_PREFIX = "city";
    static String COUNTY_PREFIX = "county";
    static String STATE_PREFIX = "state";
    static String COUNTRY_PREFIX = "country";
    static String REGION_PREFIX = "region";
    static String OTHER_PREFIX = "loc";
    static final ImmutableBiMap<Location.Type, String> LOCATION_TYPE_TO_PREFIX;
    private Taxonomy clements;

    public ClementsChecklistWriter(Taxonomy clements) {
        this.clements = clements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, ClementsChecklist checklist, Location location) throws IOException {
        try (Closeable export = null;){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            export = CsvExportLines.fromWriter(writer);
            ArrayList<CallSite> locationDescription = Lists.newArrayList();
            for (Location current = Preconditions.checkNotNull(location); current != null; current = current.getParent()) {
                if (current.getEbirdCode() != null) {
                    locationDescription.add((CallSite)((Object)(CODE_PREFIX + ":" + Locations.getLocationCode(current))));
                    break;
                }
                if (current.isBuiltInLocation()) {
                    locationDescription.add((CallSite)((Object)(ID_PREFIX + ":" + current.getId())));
                    break;
                }
                String prefix = (String)LOCATION_TYPE_TO_PREFIX.get((Object)current.getType());
                if (prefix == null) {
                    prefix = OTHER_PREFIX;
                }
                locationDescription.add((CallSite)((Object)(prefix + ":" + current.getModelName())));
            }
            export.nextLine(locationDescription.toArray(new String[0]));
            export.nextLine(new String[]{this.clements.getId(), "Common", "Scientific", "Status"});
            for (Map.Entry entry : checklist.baseChecklistMap().entrySet()) {
                SightingTaxon taxon = (SightingTaxon)entry.getKey();
                SightingTaxon.Resolved resolved = taxon.resolve(this.clements);
                String[] nextLine = new String[]{Joiner.on('/').join(taxon.getIds()), resolved.getCommonName(), resolved.getFullName(), ((Checklist.Status)((Object)entry.getValue())).text()};
                export.nextLine(nextLine);
            }
        }
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)Location.Type.city, CITY_PREFIX);
        builder.put((Object)Location.Type.country, COUNTRY_PREFIX);
        builder.put((Object)Location.Type.county, COUNTY_PREFIX);
        builder.put((Object)Location.Type.park, PARK_PREFIX);
        builder.put((Object)Location.Type.region, REGION_PREFIX);
        builder.put((Object)Location.Type.state, STATE_PREFIX);
        builder.put((Object)Location.Type.town, TOWN_PREFIX);
        LOCATION_TYPE_TO_PREFIX = builder.build();
    }
}

