/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opencsv.exceptions.CsvValidationException;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ChecklistReader;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.checklist.ClementsChecklistWriter;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyMappings;
import com.scythebill.birdlist.model.taxa.UpgradeTracker;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ClementsChecklistReader {
    private final Taxonomy clements;
    private final PredefinedLocations predefinedLocations;
    private final TaxonomyMappings taxonomyMappings;

    public ClementsChecklistReader(Taxonomy clements, PredefinedLocations predefinedLocations, TaxonomyMappings taxonomyMappings) {
        this.clements = clements;
        this.predefinedLocations = predefinedLocations;
        this.taxonomyMappings = taxonomyMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChecklistAndLocation read(ReportSet reportSet, File file) throws IOException, InvalidTaxonomyException, CsvValidationException {
        try (ImportLines importLines = null;){
            String[] nextLine;
            importLines = CsvImportLines.fromFile(file, StandardCharsets.UTF_8);
            String[] locationLine = importLines.nextLine();
            if (locationLine == null || locationLine.length == 0) {
                throw new IllegalArgumentException("No location");
            }
            String[] headerLine = importLines.nextLine();
            if (headerLine == null || headerLine.length == 0) {
                throw new IllegalArgumentException("No header");
            }
            if (headerLine.length != 4 || !"Status".equals(headerLine[3])) {
                throw new IllegalArgumentException("Invalid checklist file");
            }
            UpgradeTracker tracker = null;
            String taxonomy = headerLine[0];
            if (!this.clements.getId().equals(taxonomy)) {
                tracker = this.taxonomyMappings.getTracker(taxonomy, null);
            }
            Location location = this.getLocation(reportSet, locationLine);
            HashMap<SightingTaxon, Checklist.Status> checklistMap = Maps.newHashMap();
            while ((nextLine = importLines.nextLine()) != null) {
                SightingTaxon taxon;
                String ids = nextLine[0];
                if (ids.contains("/")) {
                    Iterable<String> split = Splitter.on('/').split(ids);
                    taxon = tracker != null ? SightingTaxons.newPossiblySpTaxon(Lists.newArrayList(tracker.getTaxonId(this.clements, split, false))) : SightingTaxons.newSpTaxon(split);
                } else {
                    taxon = tracker != null ? tracker.getChecklistResolvedTaxonId(this.clements, ids, location.getParent()) : SightingTaxons.newSightingTaxon(ids);
                }
                taxon.resolve(this.clements);
                Checklist.Status status = ChecklistReader.STATUS_TEXT.get(nextLine[3]);
                if (status == null) {
                    status = Checklist.Status.NATIVE;
                }
                checklistMap.put(taxon, status);
            }
            ChecklistAndLocation checklistAndLocation = new ChecklistAndLocation(new ClementsChecklist(checklistMap), location);
            return checklistAndLocation;
        }
    }

    public Location getLocation(ReportSet reportSet, String[] locationLine) {
        Location location;
        ArrayList<String> locationList = Lists.newArrayList(locationLine);
        Collections.reverse(locationList);
        String first = (String)locationList.remove(0);
        if (first.startsWith(ClementsChecklistWriter.CODE_PREFIX)) {
            String code = this.minusPrefix(first, ClementsChecklistWriter.CODE_PREFIX);
            location = Locations.getLocationByCodePossiblyCreating(reportSet.getLocations(), this.predefinedLocations, code);
        } else if (first.startsWith(ClementsChecklistWriter.ID_PREFIX)) {
            String id = this.minusPrefix(first, ClementsChecklistWriter.ID_PREFIX);
            location = reportSet.getLocations().getLocation(id);
        } else {
            throw new IllegalArgumentException("Unexpected identifier in checklist import: " + first);
        }
        if (location == null) {
            throw new IllegalArgumentException("Could not find: " + first);
        }
        for (String locationElement : locationList) {
            List<String> list = Splitter.on(':').limit(2).splitToList(locationElement);
            if (list.size() != 2) {
                throw new IllegalArgumentException("Unexpected identifier in checklist import: " + locationElement);
            }
            String name = list.get(1);
            Location content = location.getContent(name);
            if (content != null) {
                location = content;
                continue;
            }
            Location.Type type = (Location.Type)((Object)((ImmutableMap)((Object)ClementsChecklistWriter.LOCATION_TYPE_TO_PREFIX.inverse())).get(list.get(0)));
            location = Location.builder().setParent(location).setName(name).setType(type).build();
        }
        return location;
    }

    private String minusPrefix(String text, String prefix) {
        return text.substring(prefix.length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isClementsChecklist(File file) {
        ImportLines importLines = null;
        try {
            importLines = CsvImportLines.fromFile(file, StandardCharsets.UTF_8);
            String[] locationLine = importLines.nextLine();
            if (locationLine == null || locationLine.length == 0) {
                boolean bl = false;
                return bl;
            }
            String[] headerLine = importLines.nextLine();
            if (headerLine == null || headerLine.length == 0) {
                boolean bl = false;
                return bl;
            }
            if (headerLine.length != 4 || !"Status".equals(headerLine[3])) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (importLines != null) {
                try {
                    importLines.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class ChecklistAndLocation {
        public final Checklist checklist;
        public final Location location;

        ChecklistAndLocation(Checklist checklist, Location location) {
            this.checklist = checklist;
            this.location = location;
        }
    }

    public class InvalidTaxonomyException
    extends Exception {
    }
}

