/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClementsChecklist
implements Checklist {
    private final ImmutableMap<SightingTaxon, Checklist.Status> clementsBase;
    private ImmutableMap<SightingTaxon, Checklist.Status> cachedIoc;
    private ImmutableMap<SightingTaxon, Checklist.Status> cachedClements;

    public ClementsChecklist(Map<SightingTaxon, Checklist.Status> clements) {
        this.clementsBase = ImmutableMap.copyOf(clements);
    }

    public ImmutableMap<SightingTaxon, Checklist.Status> baseChecklistMap() {
        return this.clementsBase;
    }

    @Override
    public ImmutableSet<SightingTaxon> getTaxa(Taxonomy taxonomy) {
        ImmutableMap<SightingTaxon, Checklist.Status> map = this.getTaxaMap(taxonomy);
        return map.keySet();
    }

    @Override
    public boolean includesTaxon(Taxon taxon) {
        return this.getTaxa(taxon.getTaxonomy()).contains(SightingTaxons.newSightingTaxon(taxon.getId()));
    }

    @Override
    public boolean includesTaxon(Taxon taxon, Set<Checklist.Status> excludingStatuses) {
        Checklist.Status status = this.getStatus(taxon.getTaxonomy(), SightingTaxons.newSightingTaxon(taxon.getId()));
        if (status == null) {
            return false;
        }
        return !excludingStatuses.contains((Object)status);
    }

    @Override
    public Checklist.Status getStatus(Taxonomy taxonomy, SightingTaxon taxon) {
        if (taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
            taxon = SightingTaxons.newSightingTaxon(taxon.getId());
        }
        ImmutableMap<SightingTaxon, Checklist.Status> map = this.getTaxaMap(taxonomy);
        return map.get(taxon);
    }

    @Override
    public ImmutableSet<SightingTaxon> getTaxa(Taxonomy taxonomy, Checklist.Status status) {
        ImmutableMap<SightingTaxon, Checklist.Status> map = this.getTaxaMap(taxonomy);
        return ImmutableSet.copyOf(Maps.filterValues(map, Predicates.equalTo(status)).keySet());
    }

    @Override
    public boolean isBuiltIn() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    private ImmutableMap<SightingTaxon, Checklist.Status> getTaxaMap(Taxonomy taxonomy) {
        if (taxonomy instanceof MappedTaxonomy) {
            if (this.cachedIoc == null) {
                this.cachedIoc = this.createTaxaMap(taxonomy);
            }
            return this.cachedIoc;
        }
        if (this.cachedClements == null) {
            this.cachedClements = this.createTaxaMap(taxonomy);
        }
        return this.cachedClements;
    }

    private ImmutableMap<SightingTaxon, Checklist.Status> createTaxaMap(Taxonomy taxonomy) {
        HashMap<SightingTaxon, Checklist.Status> builder = Maps.newHashMap();
        for (Map.Entry baseEntry : this.clementsBase.entrySet()) {
            SightingTaxon.Resolved resolve = ((SightingTaxon)baseEntry.getKey()).resolve(taxonomy);
            SightingTaxon species = resolve.getParentOfAtLeastType(Taxon.Type.species);
            if (species.getType() == SightingTaxon.Type.SP) {
                for (String id : species.getIds()) {
                    builder.put(SightingTaxons.newSightingTaxon(id), (Checklist.Status)((Object)baseEntry.getValue()));
                }
                continue;
            }
            builder.put(species, (Checklist.Status)((Object)baseEntry.getValue()));
        }
        return ImmutableMap.copyOf(builder);
    }
}

