/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharSource;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ChecklistReader;
import com.scythebill.birdlist.model.checklist.SplitChecklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.io.IOException;
import java.util.Set;

class ClementsAndIocChecklist
implements Checklist {
    private Supplier<SplitChecklist> clements;
    private Supplier<SplitChecklist> ioc;
    private final String file;

    ClementsAndIocChecklist(String file, CharSource clementsSource, CharSource iocSource) {
        this.file = file;
        this.clements = Suppliers.memoize(() -> this.loadChecklist(clementsSource));
        this.ioc = Suppliers.memoize(() -> this.loadChecklist(iocSource));
    }

    @Override
    public ImmutableSet<SightingTaxon> getTaxa(Taxonomy taxonomy) {
        return this.getSplitChecklist(taxonomy).getTaxa();
    }

    @Override
    public boolean includesTaxon(Taxon taxon) {
        return this.getTaxa(taxon.getTaxonomy()).contains(SightingTaxons.newSightingTaxon(taxon.getId()));
    }

    @Override
    public boolean includesTaxon(Taxon taxon, Set<Checklist.Status> excludingStatuses) {
        Checklist.Status status = this.getStatus(taxon.getTaxonomy(), SightingTaxons.newSightingTaxon(taxon.getId()));
        if (status == null) {
            return false;
        }
        return !excludingStatuses.contains((Object)status);
    }

    @Override
    public Checklist.Status getStatus(Taxonomy taxonomy, SightingTaxon taxon) {
        return this.getSplitChecklist(taxonomy).getStatus(taxon);
    }

    @Override
    public ImmutableSet<SightingTaxon> getTaxa(Taxonomy taxonomy, Checklist.Status status) {
        return this.getSplitChecklist(taxonomy).getTaxa(status);
    }

    @Override
    public boolean isBuiltIn() {
        return true;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    private SplitChecklist loadChecklist(CharSource source) {
        SplitChecklist splitChecklist;
        ChecklistReader reader = new ChecklistReader(source.openStream());
        try {
            splitChecklist = reader.read();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return splitChecklist;
    }

    private SplitChecklist getSplitChecklist(Taxonomy taxonomy) {
        if (taxonomy instanceof MappedTaxonomy) {
            return this.ioc.get();
        }
        return this.clements.get();
    }
}

