/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ChecklistSynthesizer;
import com.scythebill.birdlist.model.checklist.ClementsAndIocChecklist;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.checklist.TransposedChecklistSynthesizer;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class Checklists {
    private static final String CSV_SUFFIX = ".csv";
    private static final String CHECKLISTS_PATH = "com/scythebill/birdlist/model/checklist/";
    private static final String CLEMENTS_CHECKLISTS_PATH = "com/scythebill/birdlist/model/checklist/clements/";
    private final ImmutableSet<String> checklistCodes;
    private final LoadingCache<String, Checklist> checklistCache;
    private final TransposedChecklistSynthesizer transposedSynthesizer;
    private final PredefinedLocations predefinedLocations;
    private static final ImmutableMultimap<String, String> SYNTHETIC_CHECKLISTS = ImmutableMultimap.builder().putAll("GB", "GB-ENG", "GB-NIR", "GB-SCT", "GB-WLS").putAll("SH", (String[])new String[]{"SH-AC", "SH-SH", "SH-TA"}).build();
    private static final ImmutableMultimap<String, String> SYNTHETIC_US_CHECKLISTS = ImmutableMultimap.builder().putAll("West Indies", "PR", "VI").putAll("Pacific Ocean", (String[])new String[]{"US-HI", "GU", "MP", "AS"}).build();
    private static final ImmutableMap<String, ImmutableSet<String>> SUPPORTED_REGIONS_WITH_EXCLUSIONS = ImmutableMap.builder().put("Europe", ImmutableSet.of("TR")).put("Asia", ImmutableSet.of()).put("Eurasia", ImmutableSet.of()).put("Africa", ImmutableSet.of()).put("Australasia", ImmutableSet.of()).put("South Polar Region", ImmutableSet.of()).put("Central America", ImmutableSet.of()).put("North America", ImmutableSet.of()).put("South America", ImmutableSet.of()).put("West Indies", ImmutableSet.of()).put("Indian Ocean", ImmutableSet.of()).put("Pacific Ocean", ImmutableSet.of()).put("Atlantic Ocean", ImmutableSet.of()).put("Arctic Ocean", ImmutableSet.of()).build();
    private static final ImmutableSet<String> MULTI_REGION_COUNTRIES = ImmutableSet.of("RU", "ID", "XX");
    private static final ImmutableSet<String> SOUTH_AMERICA_CARIBBEAN_NETHERLANDS_CODES = ImmutableSet.of("CW", "BQ-BO");
    private static final Pattern IRELAND_AND_UK_COUNTIES = Pattern.compile("^(?:GB-\\w\\w\\w-)|(?:IE-)");

    @Inject
    public Checklists(TransposedChecklistSynthesizer transposedSynthesizer, PredefinedLocations predefinedLocations) {
        this.transposedSynthesizer = transposedSynthesizer;
        this.predefinedLocations = predefinedLocations;
        List<String> checklistFiles = this.enumerateChecklistFiles();
        ImmutableSet.Builder checklistCodes = ImmutableSet.builder();
        for (String checklistFile : checklistFiles) {
            String code = checklistFile.substring(0, checklistFile.length() - CSV_SUFFIX.length());
            checklistCodes.add(code);
        }
        if (transposedSynthesizer != null) {
            checklistCodes.addAll((Iterable)SYNTHETIC_CHECKLISTS.keySet());
        }
        this.checklistCodes = checklistCodes.build();
        this.checklistCache = CacheBuilder.newBuilder().maximumSize(100L).build(new CacheLoader<String, Checklist>(){

            @Override
            public Checklist load(String code) throws Exception {
                return Checklists.this.loadChecklist(code);
            }
        });
    }

    public boolean hasChecklist(Taxonomy taxonomy, ReportSet reportSet, Location location) {
        if (!taxonomy.isBuiltIn()) {
            ExtendedTaxonomyChecklists checklists = reportSet.getExtendedTaxonomyChecklist(taxonomy.getId());
            if (checklists == null || checklists.getChecklists().isEmpty()) {
                return false;
            }
            String code = Checklists.getChecklistLocationCode(location);
            if (code != null) {
                return checklists.getChecklists().containsKey(code);
            }
            Collection<String> transposedChecklistLocations = this.transposedSynthesizer.getTransposedChecklistLocations(location);
            return transposedChecklistLocations != null;
        }
        if (reportSet.getChecklist(location) != null) {
            return true;
        }
        if ("US".equals(location.getEbirdCode())) {
            return true;
        }
        if (location.isBuiltInLocation() && location.getType() == Location.Type.region && SUPPORTED_REGIONS_WITH_EXCLUSIONS.containsKey(location.getModelName())) {
            return true;
        }
        String code = Checklists.getChecklistLocationCode(location);
        if (code != null) {
            return this.checklistCodes.contains(code);
        }
        Collection<String> transposedChecklistLocations = this.transposedSynthesizer.getTransposedChecklistLocations(location);
        return transposedChecklistLocations != null;
    }

    @Nullable
    public Checklist getChecklist(ReportSet reportSet, Taxonomy taxonomy, Location location) {
        if (!taxonomy.isBuiltIn()) {
            ExtendedTaxonomyChecklists checklists = reportSet.getExtendedTaxonomyChecklist(taxonomy.getId());
            if (checklists == null || checklists.getChecklists().isEmpty()) {
                return null;
            }
            if (location.isBuiltInLocation()) {
                String code = Checklists.getChecklistLocationCode(location);
                if (code != null) {
                    return checklists.getChecklists().get(code);
                }
                Collection<String> transposedChecklistLocations = this.transposedSynthesizer.getTransposedChecklistLocations(location);
                if (transposedChecklistLocations != null) {
                    return this.transposedSynthesizer.synthesizeChecklistInternal(reportSet, transposedChecklistLocations);
                }
            }
            return null;
        }
        Collection<String> transposedChecklistLocations = this.transposedSynthesizer.getTransposedChecklistLocations(location);
        if (transposedChecklistLocations != null) {
            return this.transposedSynthesizer.synthesizeChecklistInternal(reportSet, transposedChecklistLocations);
        }
        String locationCode = Checklists.getChecklistLocationCode(location);
        if (locationCode == null || !this.checklistCodes.contains(locationCode)) {
            return reportSet.getChecklist(location);
        }
        return this.checklistCache.getUnchecked(locationCode);
    }

    @Nullable
    public Checklist getChecklist(ReportSet reportSet, Taxonomy taxonomy, ChecklistSynthesizer checklistSynthesizer, Collection<String> locationCodes) {
        if (locationCodes == null || locationCodes.isEmpty()) {
            return null;
        }
        if (locationCodes.size() == 1) {
            Location location = Checklists.getLocation(reportSet.getLocations(), this.predefinedLocations, locationCodes.iterator().next());
            return this.getChecklist(reportSet, taxonomy, location);
        }
        List locations = locationCodes.stream().map(id -> Checklists.getLocation(reportSet.getLocations(), this.predefinedLocations, id)).filter(l -> l != null).collect(ImmutableList.toImmutableList());
        if (taxonomy.isBuiltIn()) {
            return this.transposedSynthesizer.synthesizeChecklist(reportSet, taxonomy, locations);
        }
        return checklistSynthesizer.synthesizeChecklist(taxonomy, locations);
    }

    @Nullable
    public Checklist getNearestBuiltInChecklist(Taxonomy taxonomy, @Nullable ReportSet reportSet, Location location) {
        if (!taxonomy.isBuiltIn()) {
            if (reportSet == null) {
                return null;
            }
            while (location != null) {
                Checklist checklist = this.getChecklist(reportSet, taxonomy, location);
                if (checklist != null) {
                    return checklist;
                }
                location = location.getParent();
            }
            return null;
        }
        while (location != null) {
            String locationCode = Checklists.getChecklistLocationCode(location);
            if (locationCode != null && this.checklistCodes.contains(locationCode)) {
                if (SYNTHETIC_CHECKLISTS.containsKey(locationCode)) {
                    return this.transposedSynthesizer.synthesizeChecklistInternal(reportSet, SYNTHETIC_CHECKLISTS.get((Object)locationCode));
                }
                return this.checklistCache.getUnchecked(locationCode);
            }
            location = location.getParent();
        }
        return null;
    }

    @Nullable
    public String getLocationWithNearestBuiltInChecklist(Location location) {
        while (location != null) {
            String locationCode = Checklists.getChecklistLocationCode(location);
            if (locationCode != null && this.checklistCodes.contains(locationCode)) {
                return locationCode;
            }
            location = location.getParent();
        }
        return null;
    }

    public ImmutableSet<String> checklistCodes() {
        return this.checklistCodes;
    }

    public Checklist getChecklist(String code) {
        return this.checklistCache.getUnchecked(code);
    }

    public static Collection<String> getChecklistLocationCodes(Location location) {
        String locationCode = Checklists.getChecklistLocationCode(location);
        if (locationCode == null) {
            if ("US".equals(location.getEbirdCode()) && SYNTHETIC_US_CHECKLISTS.containsKey(location.getParent().getModelName())) {
                return SYNTHETIC_US_CHECKLISTS.get((Object)location.getParent().getModelName());
            }
            if ("BQ".equals(location.getEbirdCode()) && "South America".equals(location.getParent().getModelName())) {
                return ImmutableSet.of("BQ-BO", "CW");
            }
            if ("UM".equals(location.getEbirdCode())) {
                return ImmutableSet.of("UM-71");
            }
            return ImmutableSet.of();
        }
        if (SYNTHETIC_CHECKLISTS.containsKey(locationCode)) {
            return SYNTHETIC_CHECKLISTS.get((Object)locationCode);
        }
        return ImmutableSet.of(locationCode);
    }

    public static String getChecklistLocationCode(Location location) {
        String code = Locations.getLocationCode(location);
        if ("US".equals(code) && !"North America".equals(location.getParent().getModelName())) {
            return null;
        }
        if ("BQ".equals(code) && !"West Indies".equals(location.getParent().getModelName())) {
            return null;
        }
        if ("UM".equals(code)) {
            return null;
        }
        if (MULTI_REGION_COUNTRIES.contains(code)) {
            Location builtInParentRegion = null;
            for (Location parent = location.getParent(); builtInParentRegion == null && parent != null; parent = parent.getParent()) {
                if (!parent.isBuiltInLocation() || parent.getType() != Location.Type.region) continue;
                builtInParentRegion = parent;
                break;
            }
            if (builtInParentRegion != null) {
                String parentName = builtInParentRegion.getModelName();
                return code + "-" + parentName;
            }
            return null;
        }
        return code;
    }

    public static Location getLocation(LocationSet locationSet, PredefinedLocations predefinedLocations, String code) {
        Collection<Location> locationsByCode;
        String country = code.substring(0, 2);
        boolean hasRegion = false;
        if (MULTI_REGION_COUNTRIES.contains(country)) {
            hasRegion = code.length() > 5;
        } else if ("US".equals(code) || "BQ".equals(code)) {
            hasRegion = true;
        } else if ("TR".equals(code)) {
            locationsByCode = locationSet.getLocationsByCode("TR");
            for (Location location : locationsByCode) {
                if (!location.getParent().getModelName().equals("Asia")) continue;
                return location;
            }
        } else if (SOUTH_AMERICA_CARIBBEAN_NETHERLANDS_CODES.contains(code)) {
            locationsByCode = locationSet.getLocationsByCode("BQ");
            for (Location location : locationsByCode) {
                PredefinedLocations.PredefinedLocation predefinedLocation;
                if (Checklists.getChecklistLocationCode(location) != null || (predefinedLocation = predefinedLocations.getPredefinedLocationChildByCode(location, code)) == null) continue;
                return predefinedLocation.create(locationSet, location);
            }
        }
        if (!hasRegion) {
            locationsByCode = locationSet.getLocationsByCode(code);
            if (locationsByCode.isEmpty()) {
                PredefinedLocations.PredefinedLocation predefinedLocation;
                Location countryLocation;
                if (code.length() > 3 && (countryLocation = locationSet.getLocationByCode(country)) != null && (predefinedLocation = predefinedLocations.getPredefinedLocationChildByCode(countryLocation, code)) != null) {
                    return predefinedLocation.create(locationSet, countryLocation);
                }
                return null;
            }
            return locationsByCode.iterator().next();
        }
        locationsByCode = locationSet.getLocationsByCode(country);
        for (Location location : locationsByCode) {
            if (!code.equals(Checklists.getChecklistLocationCode(location))) continue;
            return location;
        }
        return null;
    }

    private Checklist loadChecklist(String code) {
        String clementsFile = String.format("clements/%s.csv", code);
        URL clementsUrl = Resources.getResource(this.getClass(), clementsFile);
        CharSource clementsCharSource = Resources.asCharSource(clementsUrl, StandardCharsets.UTF_8);
        String iocFile = String.format("ioc/%s.csv", code);
        URL iocUrl = Resources.getResource(this.getClass(), iocFile);
        CharSource iocCharSource = Resources.asCharSource(iocUrl, StandardCharsets.UTF_8);
        return new ClementsAndIocChecklist(code, clementsCharSource, iocCharSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> enumerateChecklistFiles() {
        ArrayList<String> files;
        block7: {
            files = Lists.newArrayList();
            URL location = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            String path = location.getPath();
            if (path.endsWith(".jar")) {
                try {
                    String decodedPath = URLDecoder.decode(path, "UTF-8");
                    try (JarFile jarFile = new JarFile(decodedPath);){
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            String name;
                            JarEntry entry = entries.nextElement();
                            if (!entry.getName().startsWith(CLEMENTS_CHECKLISTS_PATH) || !entry.getName().endsWith(CSV_SUFFIX) || IRELAND_AND_UK_COUNTIES.matcher(name = entry.getName().substring(CLEMENTS_CHECKLISTS_PATH.length())).find()) continue;
                            files.add(name);
                        }
                        break block7;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            File root = new File(path);
            File checklistsDir = new File(root, CLEMENTS_CHECKLISTS_PATH);
            files.addAll(Arrays.asList(checklistsDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.endsWith(Checklists.CSV_SUFFIX) && !IRELAND_AND_UK_COUNTIES.matcher(name).find();
                }
            })));
        }
        return files;
    }

    public static ImmutableSet<String> gatherCountryChecklistCodes(Location parent) {
        ImmutableSet.Builder<String> codes = ImmutableSet.builder();
        Checklists.gatherCountryChecklistCodes(parent, codes);
        return codes.build();
    }

    public static Collection<String> getCountryChecklistCodes(ReportSet reportSet, Iterable<Trip> trips) {
        ImmutableSet.Builder checklistCodes = ImmutableSet.builder();
        ArrayList<Predicate<Sighting>> tripPredicates = new ArrayList<Predicate<Sighting>>();
        for (Trip trip : trips) {
            Location location;
            Location country;
            if (trip.locationId() != null && (country = Locations.getAncestorOfType(location = reportSet.getLocations().getLocation(trip.locationId()), Location.Type.country)) != null) {
                Collection<String> codes = Checklists.getChecklistLocationCodes(country);
                if (codes.isEmpty()) {
                    return null;
                }
                checklistCodes.addAll(codes);
                continue;
            }
            tripPredicates.add(Trips.tripPredicate(reportSet, trip, null));
        }
        if (!tripPredicates.isEmpty()) {
            Predicate predicate = Predicates.or(tripPredicates);
            ImmutableSet matchingLocations = reportSet.getSightings().stream().filter(predicate).map(Sighting::getLocationId).collect(ImmutableSet.toImmutableSet());
            for (String locationId : matchingLocations) {
                Location location = reportSet.getLocations().getLocation(locationId);
                Location country = Locations.getAncestorOfType(location, Location.Type.country);
                if (country == null) continue;
                Collection<String> codes = Checklists.getChecklistLocationCodes(country);
                if (codes.isEmpty()) {
                    return null;
                }
                checklistCodes.addAll(codes);
            }
        }
        return checklistCodes.build();
    }

    public static Collection<String> getCountryChecklistCodes(ReportSet reportSet, Collection<VisitInfoKey> visitInfoKeys) {
        ImmutableSet.Builder checklistCodes = ImmutableSet.builder();
        ImmutableSet locations = visitInfoKeys.stream().map(VisitInfoKey::locationId).collect(ImmutableSet.toImmutableSet());
        for (String locationId : locations) {
            Location location = reportSet.getLocations().getLocation(locationId);
            Location country = Locations.getAncestorOfType(location, Location.Type.country);
            if (country == null) continue;
            Collection<String> codes = Checklists.getChecklistLocationCodes(country);
            if (codes.isEmpty()) {
                return null;
            }
            checklistCodes.addAll(codes);
        }
        return checklistCodes.build();
    }

    private static void gatherCountryChecklistCodes(Location parent, ImmutableSet.Builder<String> codes) {
        for (Location child : parent.contents()) {
            if (child.isBuiltInLocation() && child.getType() != Location.Type.region) {
                codes.addAll(Checklists.getChecklistLocationCodes(child));
                continue;
            }
            String code = child.getEbirdCode();
            if (code != null && code.startsWith("XX-")) {
                codes.add((Object)code);
                continue;
            }
            Checklists.gatherCountryChecklistCodes(child, codes);
        }
    }
}

