/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.logging.Logger;

public class ChecklistSynthesizer {
    private static final Logger logger = Logger.getLogger(ChecklistSynthesizer.class.getName());
    private final ImmutableMap<Checklist.Status, Integer> STATUS_PRIORITY = ImmutableMap.builder().put(Checklist.Status.EXTINCT, 0).put(Checklist.Status.ESCAPED, 1).put(Checklist.Status.RARITY_FROM_INTRODUCED, 2).put(Checklist.Status.INTRODUCED, 3).put(Checklist.Status.RARITY, 4).put(Checklist.Status.NATIVE, 5).put(Checklist.Status.ENDEMIC, 6).build();
    private final LoadingCache<CacheKey, Optional<Checklist>> cache = CacheBuilder.newBuilder().maximumSize(10L).build(new CacheLoader<CacheKey, Optional<Checklist>>(){

        @Override
        public Optional<Checklist> load(CacheKey key) throws Exception {
            return ChecklistSynthesizer.this.createChecklist(key.locationKeys, key.taxonomy);
        }
    });
    private final Checklists checklists;
    private final ReportSet reportSet;
    private final PredefinedLocations predefinedLocations;

    @Inject
    public ChecklistSynthesizer(Checklists checklists, ReportSet reportSet, PredefinedLocations predefinedLocations) {
        this.checklists = checklists;
        this.reportSet = reportSet;
        this.predefinedLocations = predefinedLocations;
    }

    public Checklist synthesizeChecklist(Taxonomy taxonomy, Iterable<Location> locations) {
        ImmutableSet<LocationKey> locationKeys = Streams.stream(locations).map(l -> new LocationKey((Location)l)).collect(ImmutableSet.toImmutableSet());
        return this.cache.getUnchecked(new CacheKey(locationKeys, taxonomy)).orElse(null);
    }

    private Optional<Checklist> createChecklist(ImmutableSet<LocationKey> locationKeys, Taxonomy taxonomy) {
        LinkedHashMap<SightingTaxon, Checklist.Status> taxonToStatus = new LinkedHashMap<SightingTaxon, Checklist.Status>();
        for (LocationKey locationKey : locationKeys) {
            Location location = locationKey.getLocation(this.reportSet.getLocations(), this.predefinedLocations);
            if (location == null) {
                logger.warning("Could not find location " + locationKey);
                return Optional.empty();
            }
            Checklist checklist = this.checklists.getChecklist(this.reportSet, taxonomy, location);
            if (checklist == null) {
                return Optional.empty();
            }
            ImmutableSet<SightingTaxon> taxa = checklist.getTaxa(taxonomy);
            for (SightingTaxon taxon : taxa) {
                Checklist.Status newStatus = checklist.getStatus(taxonomy, taxon);
                Checklist.Status oldStatus = (Checklist.Status)((Object)taxonToStatus.get(taxon));
                if (oldStatus != null && this.STATUS_PRIORITY.get((Object)newStatus) <= this.STATUS_PRIORITY.get((Object)oldStatus)) continue;
                taxonToStatus.put(taxon, newStatus);
            }
        }
        return Optional.of(new ClementsChecklist(taxonToStatus));
    }

    static final class CacheKey {
        final ImmutableSet<LocationKey> locationKeys;
        final Taxonomy taxonomy;
        private final int hash;

        CacheKey(Iterable<LocationKey> locationKeys, Taxonomy taxonomy) {
            this.locationKeys = ImmutableSet.copyOf(locationKeys);
            this.taxonomy = taxonomy;
            this.hash = Objects.hashCode(this.locationKeys, taxonomy.getId());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return that.taxonomy == this.taxonomy && that.locationKeys.equals(this.locationKeys);
        }
    }

    static final class LocationKey {
        private final String code;
        private final String locationId;

        LocationKey(Location location) {
            String code = Locations.getLocationCode(location);
            if (code != null) {
                this.code = code;
                this.locationId = null;
            } else {
                this.code = null;
                this.locationId = location.getId();
            }
        }

        public int hashCode() {
            return Objects.hashCode(this.code, this.locationId);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof LocationKey)) {
                return false;
            }
            LocationKey other = (LocationKey)that;
            return Objects.equal(this.code, other.code) && Objects.equal(this.locationId, other.locationId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("code", this.code).add("id", this.locationId).omitNullValues().toString();
        }

        public Location getLocation(LocationSet locationSet, PredefinedLocations predefinedLocations) {
            if (this.locationId != null) {
                return locationSet.getLocation(this.locationId);
            }
            return Locations.getLocationByCodePossiblyCreating(locationSet, predefinedLocations, this.code);
        }
    }
}

