/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChecklistResolution {
    private final Checklists checklists;
    private final ImmutableSet<Checklist.Status> excludingStatuses;
    private List<Sighting> sightingsToRemove;
    private List<Sighting> sightingsToAdd;
    private Multimap<SightingTaxon, SightingTaxon> taxaMappings;
    private int simplifiedButStillSp;
    private int notSimplified;

    public ChecklistResolution(Checklists checklists, Set<Checklist.Status> excludingStatuses) {
        this.checklists = checklists;
        this.excludingStatuses = ImmutableSet.copyOf(excludingStatuses);
    }

    public List<Sighting> sightingsToRemove() {
        return Collections.unmodifiableList(this.sightingsToRemove);
    }

    public List<Sighting> sightingsToAdd() {
        return Collections.unmodifiableList(this.sightingsToAdd);
    }

    public Multimap<SightingTaxon, SightingTaxon> taxaMappings() {
        return this.taxaMappings;
    }

    public int notSimplifiedCount() {
        return this.notSimplified;
    }

    public int simplifiedButNotFullyResolved() {
        return this.simplifiedButStillSp;
    }

    public ImmutableSet<SightingTaxon> attemptChecklistResolution(ReportSet reportSet, Set<SightingTaxon> spsToResolve, Taxonomy taxonomy) {
        if (!taxonomy.isBuiltIn()) {
            throw new IllegalArgumentException("Only built-in taxonomies");
        }
        this.sightingsToRemove = Lists.newArrayList();
        this.sightingsToAdd = Lists.newArrayList();
        this.simplifiedButStillSp = 0;
        this.notSimplified = 0;
        boolean iocResolution = taxonomy instanceof MappedTaxonomy;
        ImmutableMultimap.Builder<SightingTaxon, SightingTaxon> taxaMappingsBuilder = ImmutableMultimap.builder();
        HashSet<SightingTaxon> remainingSightingTaxons = Sets.newHashSet();
        for (Sighting sighting : reportSet.getSightings()) {
            SightingTaxon oldSightingTaxon = sighting.getTaxon();
            if (!spsToResolve.contains(oldSightingTaxon)) continue;
            Location location = reportSet.getLocations().getLocation(sighting.getLocationId());
            Checklist checklist = this.checklists.getNearestBuiltInChecklist(taxonomy, reportSet, location);
            if (checklist == null) {
                remainingSightingTaxons.add(oldSightingTaxon);
                ++this.notSimplified;
                continue;
            }
            SightingTaxon newSightingTaxon = this.resolveAgainstChecklist(taxonomy, iocResolution, oldSightingTaxon, checklist);
            if (newSightingTaxon != null) {
                boolean isStillSp;
                if (iocResolution) {
                    SightingTaxon.Resolved originalMapped = oldSightingTaxon.resolve(taxonomy);
                    SightingTaxon.Resolved newMapped = newSightingTaxon.resolve(taxonomy);
                    if (originalMapped.getSightingTaxon().getIds().size() < newMapped.getSightingTaxon().getIds().size()) {
                        ++this.notSimplified;
                        remainingSightingTaxons.add(oldSightingTaxon);
                        continue;
                    }
                    isStillSp = newMapped.getType() == SightingTaxon.Type.SP;
                } else {
                    isStillSp = newSightingTaxon.getType() == SightingTaxon.Type.SP;
                }
                taxaMappingsBuilder.put(oldSightingTaxon, newSightingTaxon);
                this.sightingsToRemove.add(sighting);
                this.sightingsToAdd.add(sighting.asBuilder().setTaxon(newSightingTaxon).build());
                if (!isStillSp) continue;
                ++this.simplifiedButStillSp;
                remainingSightingTaxons.add(newSightingTaxon);
                continue;
            }
            taxaMappingsBuilder.put(oldSightingTaxon, oldSightingTaxon);
            remainingSightingTaxons.add(oldSightingTaxon);
            ++this.notSimplified;
        }
        this.taxaMappings = taxaMappingsBuilder.build();
        if (this.sightingsToAdd.isEmpty()) {
            return null;
        }
        return ImmutableSet.copyOf(remainingSightingTaxons);
    }

    public SightingTaxon resolveAgainstChecklist(Taxonomy taxonomy, boolean iocResolution, SightingTaxon oldSightingTaxon, Checklist checklist) {
        SightingTaxon newSightingTaxon = null;
        if (iocResolution) {
            SightingTaxon.Resolved originalMapped = oldSightingTaxon.resolve(taxonomy);
            if (originalMapped.getType() == SightingTaxon.Type.SP) {
                HashSet<String> plausibleIds = Sets.newHashSet();
                for (Taxon taxon : originalMapped.getTaxa()) {
                    if (!this.iocTaxonIsInIocChecklist(checklist, taxon)) continue;
                    plausibleIds.add(taxon.getId());
                }
                if (!plausibleIds.isEmpty() && plausibleIds.size() != originalMapped.getSightingTaxon().getIds().size()) {
                    newSightingTaxon = ((MappedTaxonomy)taxonomy).getMapping(SightingTaxons.newPossiblySpTaxon(plausibleIds));
                }
            }
        } else {
            HashSet<String> plausibleIds = Sets.newHashSet();
            for (String id : oldSightingTaxon.getIds()) {
                if (!this.clementsTaxonIsInClementsChecklist(taxonomy, checklist, id)) continue;
                plausibleIds.add(id);
            }
            if (plausibleIds.size() != oldSightingTaxon.getIds().size() && !plausibleIds.isEmpty()) {
                newSightingTaxon = SightingTaxons.newPossiblySpTaxon(plausibleIds);
            }
        }
        return newSightingTaxon;
    }

    private boolean clementsTaxonIsInClementsChecklist(Taxonomy clements, Checklist checklist, String id) {
        Taxon taxon = TaxonUtils.getParentOfType(clements.getTaxon(id), Taxon.Type.species);
        return checklist.includesTaxon(taxon, this.excludingStatuses);
    }

    private boolean iocTaxonIsInIocChecklist(Checklist checklist, Taxon taxon) {
        Taxon species = TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
        return checklist.includesTaxon(species, this.excludingStatuses);
    }
}

