/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.SplitChecklist;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.logging.Logger;

class ChecklistReader
implements Closeable {
    private final Reader reader;
    private static final Splitter SP_SPLITTER = Splitter.on('/');
    private static final Logger logger = Logger.getLogger(ChecklistReader.class.getName());
    static final ImmutableMap<String, Checklist.Status> STATUS_TEXT;

    public ChecklistReader(Reader reader) {
        this.reader = reader;
    }

    public SplitChecklist read() throws IOException {
        String[] nextLine;
        ImportLines importLines = CsvImportLines.fromReader(this.reader);
        importLines.nextLine();
        HashMap<SightingTaxon, Checklist.Status> taxa = Maps.newHashMap();
        while ((nextLine = importLines.nextLine()) != null) {
            Checklist.Status status = this.toStatus(nextLine[2]);
            String id = nextLine[1];
            if (id.indexOf(47) < 0) {
                taxa.put(SightingTaxons.newSightingTaxon(id), status);
                continue;
            }
            taxa.put(SightingTaxons.newSpTaxon(SP_SPLITTER.split(id)), status);
        }
        return new SplitChecklist(taxa);
    }

    private Checklist.Status toStatus(String status) {
        if (Strings.isNullOrEmpty(status)) {
            return Checklist.Status.NATIVE;
        }
        Checklist.Status statusEnum = STATUS_TEXT.get(status);
        if (statusEnum == null) {
            logger.warning("Unexpected checklist status " + status);
            return Checklist.Status.NATIVE;
        }
        return statusEnum;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static {
        ImmutableMap.Builder<String, Checklist.Status> builder = ImmutableMap.builder();
        for (Checklist.Status status : Checklist.Status.values()) {
            if (status.text() == null) continue;
            builder.put(status.text(), status);
        }
        STATUS_TEXT = builder.build();
    }
}

