/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.Set;

public interface Checklist {
    public ImmutableSet<SightingTaxon> getTaxa(Taxonomy var1);

    public ImmutableSet<SightingTaxon> getTaxa(Taxonomy var1, Status var2);

    public Status getStatus(Taxonomy var1, SightingTaxon var2);

    public boolean includesTaxon(Taxon var1);

    public boolean includesTaxon(Taxon var1, Set<Status> var2);

    public boolean isBuiltIn();

    public boolean isSynthetic();

    public static enum Status {
        NATIVE(null),
        ENDEMIC("endemic"),
        EXTINCT("extinct"),
        INTRODUCED("introduced"),
        RARITY("rarity"),
        RARITY_FROM_INTRODUCED("rarity-from-introduced"),
        ESCAPED("escaped");

        private final String text;

        private Status(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }
    }
}

