/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.app.main;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.scythebill.birdlist.app.ApplicationModule;
import com.scythebill.birdlist.app.main.MainApplicationModule;
import com.scythebill.birdlist.ui.app.FrameRegistry;
import com.scythebill.birdlist.ui.app.OtherFileLoaderRegistry;
import com.scythebill.birdlist.ui.app.Startup;
import com.scythebill.birdlist.ui.guice.CommonModule;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.panels.MainFrame;
import com.scythebill.birdlist.ui.panels.UIMode;
import com.scythebill.birdlist.ui.panels.UIPreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

@Singleton
public class App {
    private static final Logger logger = Logger.getLogger(App.class.getName());
    private final Startup startup;
    private final FrameRegistry frameRegistry;
    private final FilePreferences filePreferences;
    private final Alerts alerts;
    private final OtherFileLoaderRegistry otherFileLoaderRegistry;

    @Inject
    public App(FrameRegistry frameRegistry, Startup startup, FilePreferences filePreferences, Alerts alerts, OtherFileLoaderRegistry otherFileLoaderRegistry) {
        this.frameRegistry = frameRegistry;
        this.startup = startup;
        this.filePreferences = filePreferences;
        this.alerts = alerts;
        this.otherFileLoaderRegistry = otherFileLoaderRegistry;
    }

    public void start(final ImmutableList<String> args) {
        this.startup.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable t) {
                        logger.log(Level.SEVERE, "Unhandled exception", t);
                        App.this.alerts.reportError(t);
                    }
                });
                App.this.startup.start(() -> App.this.onGlobalsLoaded(args));
            }
        });
    }

    private void onGlobalsLoaded(ImmutableList<String> args) {
        Runnable whenNoFiles = () -> {
            this.frameRegistry.showNoOtherWindowFrame();
            this.startup.finish();
        };
        if (this.frameRegistry.isEmpty()) {
            Object file;
            if (!args.isEmpty()) {
                ArrayList<File> files = Lists.newArrayList();
                ArrayList<File> otherFiles = Lists.newArrayList();
                for (String arg : args) {
                    file = new File(arg);
                    if (!((File)file).exists()) continue;
                    if (arg.endsWith(".bsxm")) {
                        files.add((File)file);
                        continue;
                    }
                    otherFiles.add((File)file);
                }
                this.otherFileLoaderRegistry.addFiles(otherFiles);
                if (!files.isEmpty()) {
                    AtomicInteger fileCount = new AtomicInteger(files.size());
                    Runnable onFileFailure = () -> {
                        if (fileCount.decrementAndGet() == 0) {
                            whenNoFiles.run();
                        }
                    };
                    for (File file2 : files) {
                        this.frameRegistry.startLoadingReportSet(file2.getAbsolutePath(), onFileFailure);
                    }
                    return;
                }
            }
            boolean successfullyOpened = false;
            ArrayList<String> failedLoads = new ArrayList<String>();
            for (String lastLoadedReportSet : this.filePreferences.getLastLoadedReportSets()) {
                file = new File(lastLoadedReportSet);
                if (((File)file).exists()) {
                    this.frameRegistry.startLoadingReportSet(lastLoadedReportSet, whenNoFiles);
                    successfullyOpened = true;
                    continue;
                }
                String fileName = ((File)file).getName();
                if (((File)file).getParent() == null) {
                    failedLoads.add(fileName);
                    continue;
                }
                failedLoads.add(String.format(Messages.getMessage(Messages.Name.FILE_IN_DIRECTORY), fileName, ((File)file).getParent()));
            }
            if (!successfullyOpened) {
                if (!failedLoads.isEmpty()) {
                    Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
                    boolean multipleFiles = failedLoads.size() != 1;
                    this.alerts.showError(null, Messages.getMessage(multipleFiles ? Messages.Name.CANT_FIND_BSXM_FILE_TITLE : Messages.Name.CANT_FIND_BSXM_FILES_TITLE), Messages.getMessage(multipleFiles ? Messages.Name.CANT_FIND_BSXM_FILE_MESSAGE : Messages.Name.CANT_FIND_BSXM_FILES_MESSAGE) + "<br>" + failedLoads.stream().map(htmlEscaper::escape).map(s -> "<br>&nbsp;&nbsp;&nbsp;" + s).collect(Collectors.joining()) + "<br><br>" + Messages.getMessage(multipleFiles ? Messages.Name.PLEASE_SEARCH_FOR_BSXM_FILE : Messages.Name.PLEASE_SEARCH_FOR_BSXM_FILES), new Object[0]);
                }
                whenNoFiles.run();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("sun.java2d.d3d", "false");
        System.setProperty("sun.java2d.d3d.onscreen", "false");
        System.setProperty("sun.java2d.nodraw", "true");
        System.setProperty("sun.java2d.opengl", "false");
        System.setProperty("sun.java2d.metal", "false");
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            try {
                Toolkit xToolkit = Toolkit.getDefaultToolkit();
                Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(xToolkit, "Scythebill");
            }
            catch (Throwable xToolkit) {
                // empty catch block
            }
        }
        Injector injector = Guice.createInjector(new AbstractModule(){

            @Override
            protected void configure() {
                this.binder().requireAtInjectOnConstructors();
            }
        }, new MainApplicationModule(), new ApplicationModule(), new CommonModule());
        try {
            UIPreferences prefs = injector.getInstance(UIPreferences.class);
            App.initUI(prefs.uiMode);
            injector.getInstance(App.class).start(ImmutableList.copyOf(args));
        }
        catch (Exception e) {
            injector.getInstance(Alerts.class).reportError(e);
            System.exit(1);
        }
    }

    private static void initUI(UIMode uiMode) throws Exception {
        MainFrame.initCommonUI(uiMode);
        Image arrowImage = Toolkit.getDefaultToolkit().createImage(App.class.getResource("/grayarrow.png"));
        UIManager.put("Browser.expandedIcon", new ImageIcon(arrowImage));
        UIManager.put("Browser.Icon", new ImageIcon(arrowImage));
        UIManager.put("Browser.selectedExpandedIcon", new ImageIcon(arrowImage));
        UIManager.put("Browser.focusedSelectedExpandedIcon", new ImageIcon(arrowImage));
        Image sizeHandleImage = Toolkit.getDefaultToolkit().createImage(App.class.getResource("/sizeHandleIcon.png"));
        UIManager.put("Browser.sizeHandleIcon", new ImageIcon(sizeHandleImage));
        if (UIManager.getColor("List.selectionInactiveBackground") == null) {
            UIManager.put("List.selectionInactiveBackground", new Color(202, 202, 202));
        }
        if (UIManager.getColor("Tree.selectionInactiveBackground") == null) {
            UIManager.put("Tree.selectionInactiveBackground", new Color(202, 202, 202));
        }
    }
}

